/*
Tento cel sbor je licencovan pod GNU GENERAL PUBLIC LICENSE version 3 https://www.gnu.org/licenses/gpl-3.0.html
Autor: Adam Struharansk
Neexistuj absoltne iadne zruky funnosti a pouitelnosti na iaden el,
a vetci autori sa zriekaj zodpovednosti za akkovek kody vyplvajce z jeho pouitia.

There are absolutely no warranties of functionality and/or usability for any purpose,
and all authors disclaim liability for any damages resulting from its use.
*/

#ifndef FORD_FULKERSON
#define FORD_FULKERSON


#include <limits.h> 
#include <string.h> 
#include <vector>
#include <queue> 
using namespace std;

//najde cestu pomocou bfs zo zdroja (0) do ustia {grpaph.size()-1), pricom naplni cestu parent,
//kde kazdemu vrcholu napise na jeho miesto, kto je jeho rodic. vrati ci existuje cesta
bool bfs_ff(std::vector < std::vector<pair<int, int>>> graph, std::vector<int>  &parent) {
    
    std::vector<bool> visited;
    visited.assign(graph.size(), false);
    std::queue<int> fifo;
    fifo.push(0);//predpokladame, ze graf ma aspon jeden vrchol
    visited.at(0) = true;

    while (!fifo.empty()) {
        int vertex = fifo.front();
        fifo.pop();
        for (int i = 0; i < graph.at(vertex).size(); i++) {
            if (!visited.at(graph.at(vertex).at(i).first) && (graph.at(vertex).at(i).second > 0)) {
                fifo.push(graph.at(vertex).at(i).first);
                parent.at(graph.at(vertex).at(i).first) = vertex;
                visited.at(graph.at(vertex).at(i).first) = true;
            }
        }
    }

    return visited.at(graph.size()-1);
}

int ford_fulkerson_max_flown(std::vector<std::vector<pair<int,int>>> graph) {

    std::vector<int> parent;
    parent.assign(graph.size(), -1);
    int overall_max_flow = 0; 

    //budeme robit cyklus dokedy bude existovat najaka cesta zo zdroja do ustia
    while (bfs_ff(graph, parent)) { 
        int path_flow = INT_MAX;
        int i = parent.size() - 1;
        //najde sa v grafe pomocou rodicov na ceste ktoru naslo bfs hrana s najnizsou priepustnostou
        while (i != 0) {
            for (int j = 0; j < graph.at(parent.at(i)).size(); j++) {
                if (graph.at(parent.at(i)).at(j).first == i) {
                    path_flow = min(path_flow, graph.at(parent.at(i)).at(j).second);
                    i = parent.at(i);
                    break;
                }
            }
        }
        //pomocou najdenej priepustinosti sa znizi na kazdej hrane na najdenej ceste
        //a zaroven sa na opacnej hrane na tejto ceste o path_flow
        i = parent.size() - 1;
        while (i != 0) {
            int new_i = 0;
            for (int j = 0; j < graph.at(parent.at(i)).size(); j++) {
                if (graph.at(parent.at(i)).at(j).first == i) {
                    
                    if (graph.at(parent.at(i)).at(j).second == path_flow) {
                        graph.at(parent.at(i)).erase(graph.at(parent.at(i)).begin() + j);
                    }
                    else {
                        graph.at(parent.at(i)).at(j).second -= path_flow;
                    }
                    new_i = parent.at(i);
                    break;
                }
            }

            bool changed_reversed = false;
            for (int j = 0; j < graph.at(i).size(); j++) {
                if (graph.at(i).at(j).first == parent.at(i)) {
                    graph.at(i).at(j).second += path_flow;
                    changed_reversed = true;
                    break;
                }
            }
            if (!changed_reversed) {
                graph.at(i).push_back(pair<int, int>(parent.at(i), path_flow));
            }
            i = new_i;
        }

        // pridat tok tejto cesty k celkovemu toku
        overall_max_flow += path_flow;
    }

    return overall_max_flow;
}

#endif // !FORD_FULKERSON




